function [pis,npi] = get_pis()

% Computes the state invariant distributions pi's. 
%
% npi = number of invariant distributions
% pis = (4,npi) matrix whose columns are the invariant distributions

%-------
% setup
%-------

% global

global beta plr Pr_data x_data n NA NY NW jstate

% local

ERRTOL = 1.0e-7;

%-------------
% computation
%-------------

% compute taus (joint state transition probabilities)

tau = zeros(NW(1),NW(2),NW(1),NW(2)); 

for w1=1:NW(1); for w2=1:NW(2); for w1p=1:NW(1); for w2p=1:NW(2) % for each component

    tau(w1,w2,w1p,w2p) = 0.0;
    
    for a1=1:NA(1); for a2=1:NA(2); for y1=1:NY(1); for y2=1:NY(2) % sum over these variables

        if (plr(1).wp(w1,a1,y1)==w1p && plr(2).wp(w2,a2,y2)==w2p) 
            prob = plr(1).p(a1,w1)*plr(2).p(a2,w2)*Pr_data(y1,y2,a1,a2);
            tau(w1,w2,w1p,w2p) = tau(w1,w2,w1p,w2p) + prob;
        end
        
    end; end; end; end;

end; end; end; end; 

% set up tau_mat (the trasnposed transition matrix for (w1,w2))

for wnow=1:NW(1)*NW(2); for wnxt=1:NW(1)*NW(2)
    
    tau_mat(wnxt,wnow) = tau(jstate(wnow,1),jstate(wnow,2),jstate(wnxt,1),jstate(wnxt,2));
    
end; end
 
% compute eigenvalues and (right) eigenvectors of tau_mat

[evecs evals] = eig(tau_mat);

% compute the number of pi's 

npi = 0;

for k=1:NW(1)*NW(2)
    if (abs(evals(k,k)-1.0)<ERRTOL) % found unit eigenvalue 
        npi = npi + 1;
    end
end

% record the pi's

pis = zeros(NW(1)*NW(2),npi); % allocate memory of the right size

kpi = 1; % counter for pi

for l=1:NW(1)*NW(2) % loop over all eigenvectors
    if (abs(evals(l,l)-1.0)<ERRTOL) % have a valid pi
        pis(:,kpi) = evecs(:,l)/sum(evecs(:,l)); % rescale and record
        kpi = kpi+1;
    end
end
